#
# TABLE STRUCTURE FOR: tb_aplikasi
#

DROP TABLE IF EXISTS `tb_aplikasi`;

CREATE TABLE `tb_aplikasi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `logo` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_aplikasi` (`id`, `nama`, `telp`, `email`, `alamat`, `logo`) VALUES (1, 'Belajar Baca Ahe Karimun', '62811775464', 'kbtulip789@gmail.com', 'Pamak, Teluk Uma, Kec. Tebing Kab. Karimun Kepulauan Riau', 'Logo-1764381603.png');


#
# TABLE STRUCTURE FOR: tb_backupdb
#

DROP TABLE IF EXISTS `tb_backupdb`;

CREATE TABLE `tb_backupdb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `database` varchar(256) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_kelas
#

DROP TABLE IF EXISTS `tb_kelas`;

CREATE TABLE `tb_kelas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kelas` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (35, 'Miss Vivi', '2025-12-02 16:09:42');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (36, 'Mis Adhe', '2025-12-02 16:10:15');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (37, 'Mis Fatimah Bali', '2025-12-02 16:10:32');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (38, 'Miss Riska', '2025-12-16 22:11:14');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (39, 'Miss Uhty', '2025-12-20 19:28:58');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (40, 'Bu Neng', '2025-12-20 23:05:03');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (41, 'Miss Kiki', '2025-12-21 11:54:32');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (42, 'Miss Mega', '2025-12-21 14:56:56');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (43, 'Miss Fatimah Pam', '2025-12-22 16:21:48');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (44, 'Miss Intan', '2025-12-24 21:22:51');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (45, 'Miss Rini', '2025-12-24 21:29:24');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (46, 'Miss Siti', '2026-01-03 23:34:28');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (47, 'Miss Lina', '2026-01-03 23:34:46');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (48, 'Miss Rika', '2026-01-03 23:34:59');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (49, 'Miss Lia', '2026-01-03 23:37:07');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (50, 'Miss Dona', '2026-01-03 23:38:09');
INSERT INTO `tb_kelas` (`id`, `kelas`, `terdaftar`) VALUES (51, 'Miss Jehan', '2026-01-03 23:39:03');


#
# TABLE STRUCTURE FOR: tb_kelas_peserta
#

DROP TABLE IF EXISTS `tb_kelas_peserta`;

CREATE TABLE `tb_kelas_peserta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `tglLulus` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=878 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (636, 1, 466, 35, '130000', 5, 'Tidak Aktif', '2025-11-02', '2025-12-02 16:20:54');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (637, 1, 468, 38, '210000', 25, 'Aktif', '0000-00-00', '2025-12-16 22:12:31');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (638, 1, 469, 38, '130000', 4, 'Aktif', '0000-00-00', '2025-12-16 22:15:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (639, 1, 470, 38, '210000', 7, 'Aktif', '0000-00-00', '2025-12-16 22:19:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (640, 1, 471, 38, '120000', 21, 'Aktif', '0000-00-00', '2025-12-16 22:24:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (641, 1, 472, 38, '350000', 28, 'Aktif', '0000-00-00', '2025-12-16 22:25:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (642, 1, 473, 38, '130000', 1, 'Aktif', '0000-00-00', '2025-12-16 22:36:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (643, 1, 474, 38, '130000', 1, 'Aktif', '0000-00-00', '2025-12-16 22:37:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (644, 1, 475, 38, '210000', 14, 'Aktif', '0000-00-00', '2025-12-16 22:38:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (645, 1, 476, 38, '130000', 14, 'Aktif', '0000-00-00', '2025-12-16 22:39:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (646, 1, 477, 38, '200000', 24, 'Aktif', '0000-00-00', '2025-12-16 22:40:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (647, 1, 478, 38, '200000', 24, 'Aktif', '0000-00-00', '2025-12-16 22:42:23');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (648, 1, 479, 38, '210000', 15, 'Aktif', '0000-00-00', '2025-12-16 22:53:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (649, 1, 480, 38, '130000', 18, 'Aktif', '0000-00-00', '2025-12-16 22:53:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (650, 1, 481, 38, '130000', 25, 'Aktif', '0000-00-00', '2025-12-16 22:54:20');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (651, 1, 482, 38, '120000', 3, 'Aktif', '0000-00-00', '2025-12-16 22:55:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (652, 1, 483, 38, '130000', 9, 'Aktif', '0000-00-00', '2025-12-16 22:55:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (653, 1, 484, 38, '190000', 1, 'Aktif', '0000-00-00', '2025-12-16 23:02:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (654, 1, 485, 38, '130000', 10, 'Aktif', '0000-00-00', '2025-12-16 23:03:45');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (655, 1, 486, 38, '210000', 22, 'Aktif', '0000-00-00', '2025-12-16 23:04:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (656, 1, 487, 38, '300000', 1, 'Aktif', '0000-00-00', '2025-12-16 23:11:12');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (657, 1, 488, 38, '200000', 5, 'Aktif', '0000-00-00', '2025-12-16 23:11:52');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (658, 1, 489, 38, '130000', 3, 'Aktif', '0000-00-00', '2025-12-16 23:12:34');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (659, 1, 501, 36, '250000', 15, 'Aktif', '0000-00-00', '2025-12-20 17:08:34');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (660, 1, 500, 36, '210000', 10, 'Aktif', '0000-00-00', '2025-12-20 19:08:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (661, 1, 499, 36, '130000', 2, 'Aktif', '0000-00-00', '2025-12-20 19:10:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (662, 1, 498, 36, '210000', 14, 'Aktif', '0000-00-00', '2025-12-20 19:11:14');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (663, 1, 497, 36, '130000', 1, 'Aktif', '0000-00-00', '2025-12-20 19:20:43');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (664, 1, 496, 36, '150000', 1, 'Aktif', '0000-00-00', '2025-12-20 19:21:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (665, 1, 495, 36, '150000', 25, 'Aktif', '0000-00-00', '2025-12-20 19:22:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (666, 1, 494, 36, '130000', 5, 'Aktif', '0000-00-00', '2025-12-20 19:22:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (667, 1, 493, 36, '130000', 10, 'Aktif', '0000-00-00', '2025-12-20 19:23:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (668, 1, 492, 36, '210000', 4, 'Aktif', '0000-00-00', '2025-12-20 19:24:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (669, 1, 490, 36, '190000', 21, 'Aktif', '0000-00-00', '2025-12-20 19:26:29');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (670, 1, 491, 36, '130000', 10, 'Aktif', '0000-00-00', '2025-12-20 19:27:15');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (671, 1, 502, 39, '120000', 16, 'Aktif', '0000-00-00', '2025-12-20 19:35:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (672, 1, 503, 39, '200000', 10, 'Aktif', '0000-00-00', '2025-12-20 19:36:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (673, 1, 504, 39, '130000', 6, 'Aktif', '0000-00-00', '2025-12-20 19:37:43');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (674, 1, 505, 39, '300000', 2, 'Aktif', '0000-00-00', '2025-12-20 19:38:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (675, 1, 506, 39, '300000', 3, 'Aktif', '0000-00-00', '2025-12-20 23:02:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (676, 1, 507, 39, '150000', 5, 'Aktif', '0000-00-00', '2025-12-20 23:03:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (677, 1, 508, 39, '130000', 3, 'Aktif', '0000-00-00', '2025-12-20 23:03:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (678, 1, 509, 39, '190000', 7, 'Aktif', '0000-00-00', '2025-12-20 23:04:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (679, 1, 510, 41, '220000', 30, 'Aktif', '0000-00-00', '2025-12-21 12:01:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (680, 1, 511, 41, '150000', 3, 'Aktif', '0000-00-00', '2025-12-21 12:02:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (681, 1, 512, 41, '150000', 5, 'Aktif', '0000-00-00', '2025-12-21 12:02:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (682, 1, 513, 41, '150000', 17, 'Aktif', '0000-00-00', '2025-12-21 12:03:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (683, 1, 517, 41, '230000', 29, 'Aktif', '0000-00-00', '2025-12-21 12:10:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (684, 1, 516, 41, '150000', 3, 'Aktif', '0000-00-00', '2025-12-21 12:10:57');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (685, 1, 515, 41, '150000', 23, 'Aktif', '0000-00-00', '2025-12-21 12:11:34');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (686, 1, 514, 41, '230000', 5, 'Aktif', '0000-00-00', '2025-12-21 12:11:59');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (687, 1, 518, 41, '220000', 28, 'Aktif', '0000-00-00', '2025-12-21 12:17:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (688, 1, 519, 41, '150000', 28, 'Aktif', '0000-00-00', '2025-12-21 12:17:58');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (689, 1, 520, 41, '150000', 5, 'Aktif', '0000-00-00', '2025-12-21 12:21:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (690, 1, 521, 41, '150000', 10, 'Aktif', '0000-00-00', '2025-12-21 12:22:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (691, 1, 522, 41, '150000', 21, 'Aktif', '0000-00-00', '2025-12-21 12:28:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (692, 1, 523, 41, '150000', 15, 'Aktif', '0000-00-00', '2025-12-21 12:28:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (693, 1, 524, 41, '150000', 21, 'Aktif', '0000-00-00', '2025-12-21 12:33:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (694, 1, 525, 41, '150000', 27, 'Aktif', '0000-00-00', '2025-12-21 12:33:28');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (695, 1, 526, 41, '150000', 3, 'Aktif', '0000-00-00', '2025-12-21 13:41:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (696, 1, 527, 41, '150000', 3, 'Aktif', '0000-00-00', '2025-12-21 13:41:31');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (697, 1, 528, 41, '150000', 5, 'Aktif', '0000-00-00', '2025-12-21 13:45:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (698, 1, 529, 41, '230000', 4, 'Aktif', '0000-00-00', '2025-12-21 13:47:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (699, 1, 530, 41, '230000', 5, 'Aktif', '0000-00-00', '2025-12-21 13:51:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (700, 1, 531, 41, '150000', 1, 'Aktif', '0000-00-00', '2025-12-21 13:52:15');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (701, 1, 532, 41, '230000', 1, 'Aktif', '0000-00-00', '2025-12-21 13:55:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (702, 1, 533, 41, '230000', 2, 'Aktif', '0000-00-00', '2025-12-21 13:56:20');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (703, 1, 534, 42, '130000', 31, 'Aktif', '0000-00-00', '2025-12-21 14:57:29');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (704, 1, 535, 42, '130000', 12, 'Aktif', '0000-00-00', '2025-12-21 14:57:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (705, 1, 536, 42, '130000', 9, 'Aktif', '0000-00-00', '2025-12-21 15:08:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (706, 1, 537, 42, '130000', 1, 'Aktif', '0000-00-00', '2025-12-21 15:09:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (707, 1, 538, 42, '210000', 19, 'Aktif', '0000-00-00', '2025-12-21 15:12:57');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (708, 1, 539, 42, '130000', 15, 'Aktif', '0000-00-00', '2025-12-21 15:13:23');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (709, 1, 540, 42, '210000', 5, 'Aktif', '0000-00-00', '2025-12-21 19:29:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (710, 1, 541, 42, '130000', 26, 'Aktif', '0000-00-00', '2025-12-21 19:30:30');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (711, 1, 542, 42, '130000', 14, 'Aktif', '0000-00-00', '2025-12-21 19:34:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (712, 1, 543, 42, '130000', 16, 'Aktif', '0000-00-00', '2025-12-21 19:35:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (713, 1, 544, 42, '130000', 28, 'Aktif', '0000-00-00', '2025-12-21 19:39:31');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (714, 1, 545, 42, '130000', 28, 'Aktif', '0000-00-00', '2025-12-21 19:40:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (715, 1, 546, 42, '210000', 2, 'Aktif', '0000-00-00', '2025-12-21 19:43:54');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (716, 1, 547, 42, '210000', 23, 'Aktif', '0000-00-00', '2025-12-21 19:44:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (717, 1, 548, 42, '130000', 27, 'Aktif', '0000-00-00', '2025-12-21 19:48:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (718, 1, 549, 42, '130000', 5, 'Aktif', '0000-00-00', '2025-12-21 19:49:18');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (719, 1, 553, 37, '230000', 6, 'Aktif', '0000-00-00', '2025-12-22 09:30:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (720, 1, 552, 37, '150000', 23, 'Aktif', '0000-00-00', '2025-12-22 09:31:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (721, 1, 551, 37, '150000', 3, 'Aktif', '0000-00-00', '2025-12-22 09:32:03');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (722, 1, 550, 37, '150000', 8, 'Aktif', '0000-00-00', '2025-12-22 09:32:43');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (723, 1, 557, 37, '230000', 11, 'Aktif', '0000-00-00', '2025-12-22 09:41:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (724, 1, 556, 37, '150000', 16, 'Aktif', '0000-00-00', '2025-12-22 09:41:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (725, 1, 555, 37, '150000', 15, 'Aktif', '0000-00-00', '2025-12-22 09:42:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (726, 1, 554, 37, '150000', 28, 'Aktif', '0000-00-00', '2025-12-22 09:42:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (727, 1, 558, 37, '150000', 17, 'Aktif', '0000-00-00', '2025-12-22 09:48:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (728, 1, 559, 37, '150000', 21, 'Aktif', '0000-00-00', '2025-12-22 09:48:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (729, 1, 560, 37, '130000', 30, 'Aktif', '0000-00-00', '2025-12-22 09:52:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (730, 1, 561, 37, '230000', 31, 'Aktif', '0000-00-00', '2025-12-22 09:55:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (731, 1, 562, 37, '150000', 25, 'Aktif', '0000-00-00', '2025-12-22 16:14:58');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (732, 1, 563, 37, '150000', 25, 'Aktif', '0000-00-00', '2025-12-22 16:15:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (733, 1, 564, 37, '230000', 5, 'Aktif', '0000-00-00', '2025-12-22 16:18:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (734, 1, 565, 37, '0', 10, 'Aktif', '0000-00-00', '2025-12-22 16:18:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (735, 1, 566, 43, '210000', 10, 'Aktif', '0000-00-00', '2025-12-22 16:24:59');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (736, 1, 567, 43, '130000', 8, 'Aktif', '0000-00-00', '2025-12-22 16:25:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (737, 1, 568, 43, '130000', 29, 'Aktif', '0000-00-00', '2025-12-22 16:29:14');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (738, 1, 569, 43, '190000', 23, 'Aktif', '0000-00-00', '2025-12-22 16:29:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (739, 1, 573, 43, '120000', 8, 'Aktif', '0000-00-00', '2025-12-22 20:38:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (740, 1, 572, 43, '200000', 8, 'Aktif', '0000-00-00', '2025-12-22 20:39:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (741, 1, 571, 43, '210000', 4, 'Aktif', '0000-00-00', '2025-12-22 20:39:52');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (742, 1, 570, 43, '130000', 3, 'Aktif', '0000-00-00', '2025-12-22 20:40:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (743, 1, 577, 43, '130000', 14, 'Aktif', '0000-00-00', '2025-12-22 20:47:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (744, 1, 576, 43, '190000', 16, 'Aktif', '0000-00-00', '2025-12-22 20:48:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (745, 1, 575, 43, '130000', 16, 'Aktif', '0000-00-00', '2025-12-22 20:49:58');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (746, 1, 574, 43, '210000', 8, 'Aktif', '0000-00-00', '2025-12-22 20:50:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (747, 1, 583, 44, '150000', 20, 'Aktif', '0000-00-00', '2025-12-24 21:23:17');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (748, 1, 582, 44, '230000', 1, 'Aktif', '0000-00-00', '2025-12-24 21:23:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (749, 1, 581, 44, '150000', 1, 'Aktif', '0000-00-00', '2025-12-24 21:24:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (750, 1, 580, 44, '150000', 9, 'Aktif', '0000-00-00', '2025-12-24 21:24:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (751, 1, 579, 44, '150000', 9, 'Aktif', '0000-00-00', '2025-12-24 21:25:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (752, 1, 578, 44, '230000', 23, 'Aktif', '0000-00-00', '2025-12-24 21:25:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (753, 1, 584, 36, '130000', 10, 'Aktif', '0000-00-00', '2026-01-03 23:32:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (754, 1, 585, 36, '190000', 21, 'Aktif', '0000-00-00', '2026-01-03 23:33:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (755, 1, 586, 45, '300000', 2, 'Aktif', '0000-00-00', '2026-01-04 13:52:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (756, 1, 600, 45, '200000', 28, 'Aktif', '0000-00-00', '2026-01-04 13:53:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (757, 1, 599, 45, '130000', 15, 'Aktif', '0000-00-00', '2026-01-04 13:56:18');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (758, 1, 598, 45, '210000', 13, 'Aktif', '0000-00-00', '2026-01-04 13:57:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (759, 1, 597, 45, '190000', 26, 'Aktif', '0000-00-00', '2026-01-04 13:57:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (760, 1, 596, 45, '130000', 19, 'Aktif', '0000-00-00', '2026-01-04 13:58:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (761, 1, 595, 45, '130000', 19, 'Aktif', '0000-00-00', '2026-01-04 13:58:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (762, 1, 594, 45, '200000', 13, 'Aktif', '0000-00-00', '2026-01-04 13:59:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (763, 1, 593, 45, '130000', 7, 'Aktif', '0000-00-00', '2026-01-04 14:00:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (764, 1, 592, 45, '320000', 10, 'Aktif', '0000-00-00', '2026-01-04 14:01:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (765, 1, 591, 45, '300000', 29, 'Aktif', '0000-00-00', '2026-01-04 14:01:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (766, 1, 590, 45, '130000', 3, 'Aktif', '0000-00-00', '2026-01-04 14:41:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (767, 1, 589, 45, '130000', 30, 'Aktif', '0000-00-00', '2026-01-04 14:42:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (768, 1, 588, 45, '130000', 4, 'Aktif', '0000-00-00', '2026-01-04 14:42:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (769, 1, 587, 45, '130000', 8, 'Aktif', '0000-00-00', '2026-01-04 14:43:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (770, 1, 601, 50, '150000', 2, 'Aktif', '0000-00-00', '2026-01-19 21:11:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (771, 1, 623, 50, '230000', 20, 'Aktif', '0000-00-00', '2026-01-19 21:12:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (772, 1, 622, 50, '230000', 18, 'Aktif', '0000-00-00', '2026-01-19 21:13:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (773, 1, 621, 50, '150000', 14, 'Aktif', '0000-00-00', '2026-01-19 21:14:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (774, 1, 620, 50, '230000', 25, 'Aktif', '0000-00-00', '2026-01-19 21:15:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (775, 1, 619, 50, '230000', 1, 'Aktif', '0000-00-00', '2026-01-19 21:16:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (776, 1, 618, 50, '230000', 8, 'Aktif', '0000-00-00', '2026-01-19 21:17:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (777, 1, 617, 50, '230000', 2, 'Aktif', '0000-00-00', '2026-01-19 21:18:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (778, 1, 616, 50, '150000', 27, 'Aktif', '0000-00-00', '2026-01-19 21:19:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (779, 1, 615, 50, '150000', 6, 'Aktif', '0000-00-00', '2026-01-19 21:20:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (780, 1, 614, 50, '150000', 8, 'Aktif', '0000-00-00', '2026-01-19 21:42:49');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (781, 1, 613, 50, '150000', 17, 'Aktif', '0000-00-00', '2026-01-19 21:43:34');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (782, 1, 612, 50, '150000', 4, 'Aktif', '0000-00-00', '2026-01-19 21:44:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (783, 1, 611, 50, '230000', 9, 'Aktif', '0000-00-00', '2026-01-19 21:45:45');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (784, 1, 610, 50, '150000', 20, 'Aktif', '0000-00-00', '2026-01-19 21:46:52');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (785, 1, 609, 50, '150000', 21, 'Aktif', '0000-00-00', '2026-01-19 21:48:31');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (786, 1, 608, 50, '150000', 27, 'Aktif', '0000-00-00', '2026-01-19 21:49:42');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (787, 1, 607, 50, '150000', 2, 'Aktif', '0000-00-00', '2026-01-19 21:50:23');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (788, 1, 606, 50, '150000', 2, 'Aktif', '0000-00-00', '2026-01-19 21:51:14');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (789, 1, 605, 50, '150000', 21, 'Aktif', '0000-00-00', '2026-01-19 21:51:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (790, 1, 604, 50, '150000', 16, 'Aktif', '0000-00-00', '2026-01-19 21:53:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (791, 1, 603, 50, '150000', 9, 'Aktif', '0000-00-00', '2026-01-19 21:53:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (792, 1, 602, 50, '150000', 23, 'Aktif', '0000-00-00', '2026-01-19 21:54:33');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (793, 1, 642, 49, '120000', 3, 'Aktif', '0000-00-00', '2026-01-28 08:42:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (794, 1, 641, 49, '130000', 11, 'Aktif', '0000-00-00', '2026-01-28 08:42:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (795, 1, 640, 49, '0', 10, 'Aktif', '0000-00-00', '2026-01-28 08:43:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (796, 1, 639, 49, '130000', 20, 'Aktif', '0000-00-00', '2026-01-28 08:44:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (797, 1, 638, 49, '130000', 5, 'Aktif', '0000-00-00', '2026-01-28 08:44:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (798, 1, 643, 49, '190000', 30, 'Aktif', '0000-00-00', '2026-01-28 08:47:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (799, 1, 637, 49, '130000', 30, 'Aktif', '0000-00-00', '2026-01-28 08:48:40');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (800, 1, 636, 49, '130000', 4, 'Aktif', '0000-00-00', '2026-01-28 08:49:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (801, 1, 634, 49, '130000', 28, 'Aktif', '0000-00-00', '2026-01-28 08:51:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (802, 1, 633, 49, '130000', 15, 'Aktif', '0000-00-00', '2026-01-28 08:52:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (803, 1, 632, 49, '130000', 30, 'Aktif', '0000-00-00', '2026-01-28 08:53:15');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (804, 1, 631, 49, '210000', 28, 'Aktif', '0000-00-00', '2026-01-28 08:54:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (805, 1, 630, 49, '130000', 14, 'Aktif', '0000-00-00', '2026-01-28 08:54:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (806, 1, 629, 49, '130000', 16, 'Aktif', '0000-00-00', '2026-01-28 08:56:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (807, 1, 628, 49, '130000', 26, 'Aktif', '0000-00-00', '2026-01-28 08:56:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (808, 1, 635, 49, '0', 10, 'Aktif', '0000-00-00', '2026-01-28 09:01:29');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (809, 1, 627, 49, '130000', 16, 'Aktif', '0000-00-00', '2026-01-28 09:02:07');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (810, 1, 626, 49, '190000', 3, 'Aktif', '0000-00-00', '2026-01-28 09:03:13');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (811, 1, 625, 49, '130009', 3, 'Aktif', '0000-00-00', '2026-01-28 09:03:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (812, 1, 624, 49, '130000', 4, 'Aktif', '0000-00-00', '2026-01-28 09:04:28');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (813, 1, 670, 35, '130000', 21, 'Aktif', '0000-00-00', '2026-02-04 17:13:20');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (814, 1, 669, 35, '120000', 1, 'Aktif', '0000-00-00', '2026-02-04 17:13:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (815, 1, 668, 35, '130000', 16, 'Aktif', '0000-00-00', '2026-02-04 17:14:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (816, 1, 667, 35, '130000', 6, 'Aktif', '0000-00-00', '2026-02-04 17:15:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (817, 1, 666, 35, '130009', 5, 'Aktif', '0000-00-00', '2026-02-04 17:15:45');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (818, 1, 665, 35, '130000', 1, 'Aktif', '0000-00-00', '2026-02-04 17:16:14');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (819, 1, 664, 35, '130000', 30, 'Aktif', '0000-00-00', '2026-02-04 17:16:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (820, 1, 663, 35, '120009', 6, 'Aktif', '0000-00-00', '2026-02-04 17:17:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (821, 1, 662, 35, '120000', 27, 'Aktif', '0000-00-00', '2026-02-04 17:17:36');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (822, 1, 661, 35, '210000', 15, 'Aktif', '0000-00-00', '2026-02-04 17:18:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (823, 1, 660, 35, '300000', 9, 'Aktif', '0000-00-00', '2026-02-04 17:18:32');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (824, 1, 659, 35, '130000', 18, 'Aktif', '0000-00-00', '2026-02-04 17:19:08');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (825, 1, 658, 35, '210000', 6, 'Aktif', '0000-00-00', '2026-02-04 17:19:37');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (826, 1, 657, 35, '210000', 17, 'Aktif', '0000-00-00', '2026-02-04 17:20:10');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (827, 1, 656, 35, '130000', 10, 'Aktif', '0000-00-00', '2026-02-04 17:20:38');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (828, 1, 655, 35, '130000', 27, 'Aktif', '0000-00-00', '2026-02-04 17:21:18');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (829, 1, 654, 35, '130000', 14, 'Aktif', '0000-00-00', '2026-02-04 17:21:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (830, 1, 653, 35, '130000', 31, 'Aktif', '0000-00-00', '2026-02-04 17:22:18');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (831, 1, 652, 35, '120000', 10, 'Aktif', '0000-00-00', '2026-02-04 17:22:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (832, 1, 651, 35, '120000', 8, 'Aktif', '0000-00-00', '2026-02-04 17:24:16');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (833, 1, 650, 35, '210000', 15, 'Aktif', '0000-00-00', '2026-02-04 17:24:56');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (834, 1, 649, 35, '120000', 28, 'Aktif', '0000-00-00', '2026-02-04 17:25:24');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (835, 1, 648, 35, '210000', 15, 'Aktif', '0000-00-00', '2026-02-04 17:26:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (836, 1, 647, 35, '130000', 10, 'Aktif', '0000-00-00', '2026-02-04 17:26:31');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (837, 1, 646, 35, '120000', 2, 'Aktif', '0000-00-00', '2026-02-04 17:26:58');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (838, 1, 645, 35, '130000', 15, 'Aktif', '0000-00-00', '2026-02-04 17:27:20');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (839, 1, 644, 35, '210000', 29, 'Aktif', '0000-00-00', '2026-02-04 17:27:48');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (840, 1, 466, 48, '150000', 10, 'Aktif', '0000-00-00', '2026-02-04 17:29:53');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (841, 1, 671, 35, '260000', 30, 'Aktif', '0000-00-00', '2026-02-04 17:36:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (842, 1, 673, 46, '150000', 3, 'Aktif', '0000-00-00', '2026-02-04 22:50:46');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (843, 1, 672, 46, '150000', 30, 'Aktif', '0000-00-00', '2026-02-04 22:51:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (844, 1, 676, 46, '150000', 3, 'Aktif', '0000-00-00', '2026-02-05 07:37:28');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (845, 1, 675, 46, '150000', 30, 'Aktif', '0000-00-00', '2026-02-05 07:38:06');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (846, 1, 674, 46, '100000', 12, 'Aktif', '0000-00-00', '2026-02-05 07:38:51');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (847, 1, 677, 46, '230000', 10, 'Aktif', '0000-00-00', '2026-02-05 07:44:04');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (848, 1, 678, 46, '150000', 27, 'Aktif', '0000-00-00', '2026-02-05 07:44:35');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (849, 1, 679, 46, '150000', 3, 'Aktif', '0000-00-00', '2026-02-05 07:49:47');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (850, 1, 680, 46, '150000', 5, 'Aktif', '0000-00-00', '2026-02-05 07:50:22');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (851, 1, 681, 46, '150000', 2, 'Aktif', '0000-00-00', '2026-02-05 07:58:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (852, 1, 682, 46, '230000', 27, 'Aktif', '0000-00-00', '2026-02-05 07:59:09');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (853, 1, 683, 46, '230000', 30, 'Aktif', '0000-00-00', '2026-02-05 08:02:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (854, 1, 684, 46, '150000', 30, 'Aktif', '0000-00-00', '2026-02-05 08:03:02');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (855, 1, 685, 46, '150000', 1, 'Aktif', '0000-00-00', '2026-02-05 08:06:29');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (856, 1, 686, 46, '230000', 2, 'Aktif', '0000-00-00', '2026-02-05 08:06:55');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (857, 1, 691, 51, '150000', 28, 'Aktif', '0000-00-00', '2026-02-05 08:44:42');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (858, 1, 690, 51, '150000', 16, 'Aktif', '0000-00-00', '2026-02-05 08:45:12');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (859, 1, 689, 51, '230000', 14, 'Aktif', '0000-00-00', '2026-02-05 08:45:44');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (860, 1, 688, 51, '230000', 10, 'Aktif', '0000-00-00', '2026-02-05 08:46:33');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (861, 1, 687, 51, '150000', 28, 'Aktif', '0000-00-00', '2026-02-05 08:47:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (862, 1, 692, 51, '300000', 9, 'Tidak Aktif', '2025-12-10', '2026-02-06 16:10:25');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (863, 1, 693, 51, '300000', 9, 'Tidak Aktif', '2025-12-10', '2026-02-06 16:10:50');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (864, 1, 694, 51, '150000', 9, 'Aktif', '0000-00-00', '2026-02-06 16:11:21');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (865, 1, 695, 51, '150000', 10, 'Aktif', '0000-00-00', '2026-02-06 16:20:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (866, 1, 696, 51, '200000', 6, 'Aktif', '0000-00-00', '2026-02-06 16:21:05');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (867, 1, 697, 51, '230000', 16, 'Aktif', '0000-00-00', '2026-02-06 16:21:33');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (868, 1, 698, 51, '150000', 21, 'Aktif', '0000-00-00', '2026-02-06 16:22:01');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (869, 1, 699, 51, '230000', 19, 'Aktif', '0000-00-00', '2026-02-06 16:22:26');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (870, 1, 700, 51, '150000', 19, 'Aktif', '0000-00-00', '2026-02-07 10:42:27');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (871, 1, 701, 51, '230000', 20, 'Aktif', '0000-00-00', '2026-02-07 10:43:00');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (872, 1, 702, 51, '350000', 28, 'Aktif', '0000-00-00', '2026-02-07 10:43:39');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (873, 1, 703, 51, '150000', 16, 'Aktif', '0000-00-00', '2026-02-07 10:44:19');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (874, 1, 704, 51, '230000', 6, 'Aktif', '0000-00-00', '2026-02-07 10:50:41');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (875, 1, 705, 51, '200000', 5, 'Aktif', '0000-00-00', '2026-02-07 10:51:11');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (876, 1, 706, 51, '230000', 8, 'Aktif', '0000-00-00', '2026-02-07 10:51:33');
INSERT INTO `tb_kelas_peserta` (`id`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `tglLulus`, `terdaftar`) VALUES (877, 1, 707, 44, '230000', 10, 'Aktif', '0000-00-00', '2026-02-07 10:51:59');


#
# TABLE STRUCTURE FOR: tb_log
#

DROP TABLE IF EXISTS `tb_log`;

CREATE TABLE `tb_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idUser` int(11) NOT NULL,
  `ipAddress` varchar(32) NOT NULL,
  `device` text NOT NULL,
  `status` varchar(16) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4035 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4000, 1, '2404:c0:b602:ff62:6c44:c6b2:c857', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Login', '2025-11-29 08:59:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4001, 1, '2404:c0:b602:ff62:6c44:c6b2:c857', 'Mozilla/5.0 (X11; CrOS x86_64 14541.0.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36', 'Logout', '2025-11-29 09:00:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4002, 1, '114.125.47.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2025-11-29 09:43:11');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4003, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2025-12-02 16:03:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4004, 1, '103.248.217.182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2025-12-03 22:06:20');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4005, 1, '103.248.217.182', 'Mozilla/5.0 (X11; CrOS x86_64 14816.131.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36', 'Login', '2025-12-16 22:01:22');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4006, 1, '2404:c0:5010::72f:6ba', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2025-12-20 16:40:26');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4007, 1, '103.248.217.182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2025-12-21 11:53:02');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4008, 1, '103.248.217.182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2025-12-22 09:20:56');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4009, 1, '103.248.217.182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2025-12-24 21:06:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4010, 1, '103.248.217.182', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137 Version/11.1.1 Safari/605.1.15', 'Login', '2026-01-03 23:10:51');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4011, 1, '2402:1980:8eb:35a4:387c:5401:670', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-01-04 12:35:46');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4012, 1, '2402:1980:88c5:b798:2d40:97bf:4e', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-04 14:40:04');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4013, 1, '182.1.43.82', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-13 16:14:32');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4014, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-01-13 18:53:53');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4015, 1, '182.4.69.46', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-14 11:04:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4016, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-01-19 19:54:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4017, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-19 21:03:58');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4018, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-01-22 08:51:31');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4019, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-28 07:08:48');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4020, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-01-28 08:23:47');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4021, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-02-02 11:28:06');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4022, 1, '182.2.4.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-03 17:07:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4023, 1, '182.2.4.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-03 17:29:50');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4024, 1, '103.248.217.184', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-03 18:11:07');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4025, 1, '103.248.217.182', 'Mozilla/5.0 (iPad; CPU OS 16_7_11 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/137.0.7151.107 Mobile/15E148 Safari/604.1', 'Login', '2026-02-04 11:06:28');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4026, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-04 11:14:12');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4027, 1, '2404:c0:5010::ef5:826d', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-04 17:12:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4028, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-04 22:35:27');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4029, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-05 07:31:25');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4030, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-05 08:30:34');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4031, 1, '2404:c0:5010::f4b:132e', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-06 16:02:10');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4032, 1, '2404:c0:5010::f4b:132e', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-06 16:12:42');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4033, 1, '103.248.217.182', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-07 10:35:44');
INSERT INTO `tb_log` (`id`, `idUser`, `ipAddress`, `device`, `status`, `terdaftar`) VALUES (4034, 1, '182.2.7.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 18_6_2 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/18.6 Mobile/15E148 Safari/604.1', 'Login', '2026-02-11 20:11:07');


#
# TABLE STRUCTURE FOR: tb_qris
#

DROP TABLE IF EXISTS `tb_qris`;

CREATE TABLE `tb_qris` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gambar` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_rekening
#

DROP TABLE IF EXISTS `tb_rekening`;

CREATE TABLE `tb_rekening` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `namaBank` varchar(10) NOT NULL,
  `noRekening` varchar(20) NOT NULL,
  `pemilik` varchar(50) NOT NULL,
  `terdaftar` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: tb_setting
#

DROP TABLE IF EXISTS `tb_setting`;

CREATE TABLE `tb_setting` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama_subdomain` varchar(100) DEFAULT NULL,
  `expired_at` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_setting` (`id`, `nama_subdomain`, `expired_at`) VALUES (1, 'ahekarimun', '2026-11-30');


#
# TABLE STRUCTURE FOR: tb_siswa
#

DROP TABLE IF EXISTS `tb_siswa`;

CREATE TABLE `tb_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `noInduk` varchar(16) NOT NULL,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(16) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `tglLahir` date NOT NULL,
  `tglMasuk` date NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=708 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (466, '001', 'Izdan', 'Laki-Laki', '0811775464', '2018-11-02', '2024-12-02', '2025-12-02 16:14:04');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (467, '002', 'Syafiq', 'Laki-Laki', '0811775464', '2016-12-02', '2025-10-10', '2025-12-02 16:23:45');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (468, '00012025', 'Kirana Azkadina Altas', 'Perempuan', '082170993384', '2019-03-31', '2025-08-25', '2025-12-16 22:10:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (469, '00022025', 'Akifah Naila', 'Perempuan', '082260086155', '2017-09-18', '2025-09-04', '2025-12-16 22:14:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (470, '00032025', 'Adam Rizqi Habibie', 'Laki-Laki', '081270049662', '2019-12-19', '2025-10-07', '2025-12-16 22:19:14');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (471, '00042025', 'Nur Rizqa Wati', 'Perempuan', '085265311855', '2020-09-25', '2025-07-21', '2025-12-16 22:21:42');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (472, '00052025', 'Zain Waliq Khairul Hisyam', 'Laki-Laki', '087828298360', '2017-06-24', '2025-07-28', '2025-12-16 22:23:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (473, '00062025', 'Mecca Yuri An Najma', 'Perempuan', '085272608487', '2019-04-09', '2023-12-01', '2025-12-16 22:27:39');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (474, '00072025', 'Sarfaraz Yuri As Shafiulla', 'Laki-Laki', '085272608487', '2020-07-17', '2025-07-01', '2025-12-16 22:29:28');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (475, '00082025', 'Naufal Afkar', 'Laki-Laki', '082384346191', '2016-09-02', '2024-12-14', '2025-12-16 22:31:18');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (476, '00092025', 'Qiana Syazfa', 'Perempuan', '082384346191', '2020-07-06', '2025-01-14', '2025-12-16 22:33:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (477, '00102025', 'Nafeeza Syafiqha', 'Perempuan', '085376773551', '2018-12-30', '2025-09-02', '2025-12-16 22:34:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (478, '00112025', 'Khodijah Al-Qubro', 'Perempuan', '083159108903', '2017-12-18', '2025-08-24', '2025-12-16 22:36:09');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (479, '00122025', 'Rizkya Amaira Husna Kahardi', 'Perempuan', '088708325011', '2020-02-26', '2025-07-15', '2025-12-16 22:44:47');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (480, '00132025', 'Shafana Alysa Shakira', 'Perempuan', '083124536677', '2018-01-03', '2023-12-18', '2025-12-16 22:46:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (481, '00142025', 'Alfarizi Sagufta Meka', 'Laki-Laki', '081266567134', '2018-09-07', '2025-08-25', '2025-12-16 22:49:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (482, '00152025', 'Achmad Izzan Umara Nizam', 'Laki-Laki', '08116935726', '2020-04-21', '2025-08-03', '2025-12-16 22:50:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (483, '00162025', 'Unna Mikayla Muswandi', 'Perempuan', '082287097354', '2019-09-25', '2025-10-09', '2025-12-16 22:52:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (484, '00172025', 'Kenzie Alfariski Rinaandri', 'Laki-Laki', '085265354647', '2021-04-02', '2025-10-01', '2025-12-16 22:58:09');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (485, '00182025', 'Nabiil Az Zhafran', 'Laki-Laki', '085363099887', '2020-04-27', '2025-08-10', '2025-12-16 23:00:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (486, '00192025', 'Arumi Nasha Razeta', 'Perempuan', '081378011177', '2019-06-10', '2025-09-22', '2025-12-16 23:01:27');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (487, '00202025', 'Muhammad Farel', 'Laki-Laki', '085215416622', '2019-10-09', '2025-10-01', '2025-12-16 23:06:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (488, '00212025', 'Ayunda Pratiwi Setiadi', 'Perempuan', '085760866263', '2016-10-30', '2025-09-05', '2025-12-16 23:08:42');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (489, '00222025', 'Arisha Khalida Putri', 'Perempuan', '082385932567', '2019-08-16', '2025-11-03', '2025-12-16 23:10:39');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (490, '0023205', 'Aisha Zaen Salsabila', 'Perempuan', '085975286682', '2020-06-14', '2025-06-21', '2025-12-20 16:45:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (491, '00242025', 'Shafiyah Prastya', 'Perempuan', '082258545542', '2019-10-23', '2025-08-10', '2025-12-20 16:46:57');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (492, '00252025', 'Atha Shaquilla Alfarezy', 'Laki-Laki', '082288004592', '2020-12-08', '2025-06-04', '2025-12-20 16:48:18');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (493, '00262025', 'Hifza Shanum Basyasya', 'Perempuan', '082285208484', '2019-07-25', '2024-01-10', '2025-12-20 16:51:34');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (494, '00272025', 'Muhammad Ghibran Alhusayn', 'Laki-Laki', '082285130010', '2019-11-12', '2025-03-05', '2025-12-20 16:53:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (495, '00282025', 'Najwa Putri', 'Perempuan', '082288567874', '2018-01-30', '2025-05-25', '2025-12-20 16:54:55');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (496, '00292025', 'M. Al khairi', 'Laki-Laki', '082288529612', '2016-12-30', '2022-12-10', '2025-12-20 16:56:47');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (497, '00302025', 'Kayla Nadhifa A', 'Perempuan', '082288529612', '2020-11-04', '2025-08-01', '2025-12-20 17:00:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (498, '00312025', 'Akselia Deanda Alfarezel', 'Perempuan', '081372091011', '2018-12-12', '2025-07-14', '2025-12-20 17:01:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (499, '00322025', 'Hanif Ibrahim', 'Laki-Laki', '085264016910', '2020-10-09', '2025-06-02', '2025-12-20 17:02:55');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (500, '00332025', 'Zahra Amelia Rizqi', 'Perempuan', '085836600856', '2019-08-28', '2025-06-10', '2025-12-20 17:04:38');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (501, '00332025', 'Harrison Kho', 'Laki-Laki', '082385365559', '2019-01-29', '2025-07-15', '2025-12-20 17:05:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (502, '00342025', 'Aqella', 'Perempuan', '082284932233', '2021-02-20', '2025-01-16', '2025-12-20 19:30:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (503, '00352025', 'Muhammad Kiki Nurji', 'Laki-Laki', '082289117805', '2017-12-26', '2025-07-10', '2025-12-20 19:32:08');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (504, '00362025', 'Abdul ghaffar Alfarizqi Sucahyo', 'Laki-Laki', '085762566848', '2019-09-21', '2025-10-06', '2025-12-20 19:33:53');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (505, '00372025', 'M. Alfi Albuqhari', 'Laki-Laki', '081372919691', '2020-10-24', '2025-10-02', '2025-12-20 19:35:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (506, '00382025', 'M. Rizki Ramadhani ', 'Laki-Laki', '082387160039', '2015-06-25', '2024-12-03', '2025-12-20 22:56:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (507, '00392025', 'M. Arrasyid', 'Laki-Laki', '081261567884', '2025-12-02', '2024-08-05', '2025-12-20 22:59:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (508, '00402025', 'Nur Nilam Sari', 'Perempuan', '082386090851', '2019-09-24', '2025-09-03', '2025-12-20 23:00:37');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (509, '00412025', 'Ines Jovita', 'Perempuan', '081370807114', '2020-08-13', '2025-10-07', '2025-12-20 23:02:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (510, '00422025', 'Muhammad Haziq', 'Laki-Laki', '083157622986', '2019-12-17', '2025-04-30', '2025-12-21 11:56:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (511, '00432025', 'Anggun Anggraini', 'Perempuan', '081370591003', '2018-06-02', '2023-08-03', '2025-12-21 11:58:08');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (512, '00442025', 'M. Taqy Alfarishy', 'Laki-Laki', '081264400892', '2020-09-17', '2025-11-05', '2025-12-21 11:59:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (513, '00452025', 'M. Ali Andipta', 'Laki-Laki', '082171899774', '2021-11-06', '2021-11-06', '2025-12-21 12:01:02');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (514, '00462025', 'M. Adam Barzan Saragih', 'Laki-Laki', '081365660868', '2019-06-17', '2025-08-05', '2025-12-21 12:05:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (515, '00472025', 'M. Wildan Fakhri', 'Laki-Laki', '081360305599', '2020-09-19', '2025-09-23', '2025-12-21 12:06:38');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (516, '00482025', 'Alya Kinana Wahyudi', 'Laki-Laki', '085264468984', '2020-08-31', '2025-06-03', '2025-12-21 12:08:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (517, '00492025', 'Aldan Satya Hakim', 'Laki-Laki', '083166090956', '2019-02-14', '2024-04-29', '2025-12-21 12:10:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (518, '00502025', 'Dziya Sherin Hafiza', 'Perempuan', '085834657970', '2019-03-30', '2025-10-17', '2025-12-21 12:15:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (519, '00512025', 'Dhito Fahri Diyanto', 'Laki-Laki', '085835461321', '2019-09-11', '2025-04-28', '2025-12-21 12:16:59');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (520, '00522025', 'Sofyan Ats Tsauri', 'Laki-Laki', '081274639303', '2019-07-17', '2025-08-05', '2025-12-21 12:20:07');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (521, '00532025', 'Aditya Maulana Zuhdi', 'Laki-Laki', '085265454737', '2017-12-14', '2024-07-10', '2025-12-21 12:21:25');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (522, '00542025', 'Daftar Fathian Al Zuhdi', 'Laki-Laki', '085265454737', '2020-01-05', '2025-07-15', '2025-12-21 12:25:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (523, '00552025', 'Umair Malik Abadi', 'Laki-Laki', '081277690004', '2017-02-07', '2023-07-21', '2025-12-21 12:27:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (524, '00562025', 'Naina Mikayla Abadi', 'Perempuan', '081277690004', '2020-03-20', '2025-04-21', '2025-12-21 12:30:59');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (525, '00572025', 'M. Uwais Al Furqon', 'Laki-Laki', '081364000840', '2018-06-27', '2024-10-02', '2025-12-21 12:32:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (526, '00582025', 'Zidan Riga Muhammad ', 'Laki-Laki', '085762684707', '2019-04-25', '2024-04-03', '2025-12-21 13:25:48');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (527, '00592025', 'Zikri Riga Muhammad', 'Laki-Laki', '087562684707', '2019-04-25', '2024-04-03', '2025-12-21 13:40:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (528, '00602025', 'Ihza Rahma Larasati', 'Perempuan', '089507010703', '2020-11-12', '2024-03-05', '2025-12-21 13:44:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (529, '00612025', 'Oudellya Sarasvati', 'Perempuan', '081374280365', '2021-02-28', '2025-09-04', '2025-12-21 13:47:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (530, '00622025', 'Queena Areta Leticia', 'Perempuan', '081261837336', '2019-11-12', '2025-11-04', '2025-12-21 13:49:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (531, '00632025', 'M. Rasya Fadilah', 'Laki-Laki', '082173542934', '2020-10-04', '2025-12-01', '2025-12-21 13:51:21');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (532, '00642025', 'Raja Akbar Destana', 'Laki-Laki', '082284278535', '2020-12-30', '2025-12-01', '2025-12-21 13:53:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (533, '00652025', 'Hafizhan Raffa Khairy', 'Laki-Laki', '082283860252', '2020-07-13', '2025-12-02', '2025-12-21 13:55:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (534, '00662025', 'Muhammad Fattah Faturahman', 'Laki-Laki', '085315820471', '2020-10-09', '2023-05-31', '2025-12-21 14:43:46');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (535, '00672025', 'Anindhita Alesha Dzikra Putri Sofyan', 'Perempuan', '082170788196', '2017-01-28', '2023-07-21', '2025-12-21 14:45:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (536, '00682025', 'Auxilia Aspiranda', 'Perempuan', '081277998686', '2021-09-21', '2025-10-09', '2025-12-21 15:06:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (537, '00692025', 'M. Nabil Chaniago', 'Laki-Laki', '082284155757', '2021-11-29', '2025-12-01', '2025-12-21 15:07:52');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (538, '00702025', 'M. Azka Alfatih', 'Laki-Laki', '081378481595', '2016-07-28', '2024-02-19', '2025-12-21 15:10:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (539, '00712025', 'Arsyla Azwani Putri', 'Perempuan', '085375931785', '2019-06-20', '2024-07-15', '2025-12-21 15:12:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (540, '00722025', 'M. Arasyid', 'Laki-Laki', '081261567884', '2019-12-02', '2024-08-05', '2025-12-21 19:27:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (541, '00732025', 'Ripan Arfada', 'Laki-Laki', '085767416791', '2018-10-18', '2025-06-26', '2025-12-21 19:29:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (542, '00742025', 'Ayana Fisabililah', 'Perempuan', '081277998705', '2020-11-28', '2025-06-14', '2025-12-21 19:32:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (543, '00752025', 'Alisya Kirana Zanubah', 'Perempuan', '0895385173105', '2020-12-25', '2025-07-16', '2025-12-21 19:34:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (544, '00762025', 'Rahmat Sidiq', 'Laki-Laki', '082384804710', '2019-10-03', '2019-07-28', '2025-12-21 19:37:21');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (545, '00772025', 'Ramdani', 'Laki-Laki', '082386785465', '2020-04-30', '2025-07-28', '2025-12-21 19:39:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (546, '00782025', 'Khamza Dwi Alia Sutiyadi', 'Perempuan', '085760066263', '2020-06-12', '2025-09-02', '2025-12-21 19:42:23');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (547, '00792025', 'Arsya', 'Laki-Laki', '082287652001', '2019-04-17', '2025-01-23', '2025-12-21 19:43:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (548, '00802025', 'Rasha Muhammad', 'Laki-Laki', '085375331747', '2017-10-10', '2023-10-27', '2025-12-21 19:46:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (549, '00812025', 'Gaishan Rafasya', 'Laki-Laki', '082386779567', '2020-07-25', '2025-11-05', '2025-12-21 19:47:50');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (550, '00822025', 'Divia Arsyakira', 'Perempuan', '082383988315', '2017-10-23', '2024-08-08', '2025-12-22 09:25:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (551, '00832025', 'Aksa Azri Ardhitama', 'Laki-Laki', '081270099422', '2018-09-19', '2024-09-03', '2025-12-22 09:26:14');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (552, '00842025', 'Mika Nadini Arsyila', 'Perempuan', '087868713133', '2017-08-13', '2024-09-23', '2025-12-22 09:27:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (553, '00852025', 'Atmadeva Radika Sadhil', 'Laki-Laki', '081225888566', '2020-04-28', '2025-01-06', '2025-12-22 09:29:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (554, '00862025', 'Abdiel Affan', 'Laki-Laki', '082283860252', '2018-03-02', '2022-11-28', '2025-12-22 09:35:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (555, '00872025', 'Ayra Shaida Harza', 'Perempuan', '08981633417', '2019-07-09', '2025-05-15', '2025-12-22 09:37:08');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (556, '00882025', 'Rafasha Sagufta Prasetya', 'Laki-Laki', '081268916569', '2018-12-12', '2025-05-16', '2025-12-22 09:39:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (557, '00892025', 'Dinda Selvina Putri', 'Perempuan', '085760339962', '2020-09-04', '2025-06-11', '2025-12-22 09:40:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (558, '00902025', 'Yazid Salahuddin Albatami', 'Laki-Laki', '082313562787', '2018-04-20', '2025-07-17', '2025-12-22 09:45:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (559, '00912025', 'Noni Putri Chaniago ', 'Perempuan', '081374864024', '2020-11-11', '2025-07-21', '2025-12-22 09:47:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (560, '00922025', 'Rayyan Alfarizqi Ramadhan', 'Laki-Laki', '08117711091', '2022-04-09', '2025-06-30', '2025-12-22 09:50:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (561, '00932025', 'Muhammad Yafi Nurafiyyah', 'Laki-Laki', '083844282973', '2018-01-02', '2025-07-31', '2025-12-22 09:51:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (562, '00942025', 'Fatih Azkayra Filzah', 'Perempuan', '085272029646', '2017-10-25', '2023-07-25', '2025-12-22 16:13:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (563, '00952025', 'Muhammad Rafa Azka Putra', 'Laki-Laki', '081536147771', '2017-01-31', '2024-10-25', '2025-12-22 16:14:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (564, '00962025', 'Muhammad Handara Ali Mirza', 'Laki-Laki', '081276657807', '2020-05-28', '2025-08-05', '2025-12-22 16:16:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (565, '00972025', 'Khori', 'Perempuan', '082268906817', '2018-07-24', '2025-07-10', '2025-12-22 16:17:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (566, '00982025', 'Vania Eliyah Hafidzah', 'Perempuan', '081378568078', '2018-03-26', '2025-03-10', '2025-12-22 16:23:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (567, '00992025', 'Aboy Syahputra', 'Laki-Laki', '081378485592', '2017-05-22', '2025-09-08', '2025-12-22 16:24:33');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (568, '01002025', 'Aquila Wiyuka Hutapea', 'Perempuan', '082227397291', '2020-12-11', '2025-07-29', '2025-12-22 16:27:06');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (569, '01012025', 'Clara Khumaira', 'Perempuan', '081283704041', '2020-05-31', '2025-09-23', '2025-12-22 16:28:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (570, '01022025', 'Gilang Pradika', 'Laki-Laki', '082170727147', '2019-06-30', '2025-06-03', '2025-12-22 20:32:55');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (571, '01032025', 'Alfatih Raditya Kurniawan', 'Laki-Laki', '081363136457', '2018-03-31', '2025-06-04', '2025-12-22 20:34:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (572, '01042025', 'Muhammad Kenzie Rafardhan Diyanto', 'Laki-Laki', '082285119119', '2019-05-04', '2025-07-08', '2025-12-22 20:36:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (573, '01052025', 'Sameera Moussa Putri Diyanto', 'Perempuan', '082285119119', '2020-11-10', '2025-07-08', '2025-12-22 20:38:28');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (574, '01062025', 'Muhammad Azizan ', 'Laki-Laki', '085263202014', '2020-03-04', '2025-09-08', '2025-12-22 20:43:48');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (575, '01072025', 'Muhammad Raffan ', 'Laki-Laki', '081277816171', '2025-07-22', '2024-07-16', '2025-12-22 20:44:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (576, '01082025', 'Kenzie Ariva Argadinata ', 'Laki-Laki', '085356881101', '2020-06-14', '2025-10-16', '2025-12-22 20:46:23');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (577, '01092025', 'Aura Muna', 'Perempuan', '085264372167', '2020-07-07', '2025-07-14', '2025-12-22 20:47:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (578, '01102025', 'Adifa Ananda Hafiz', 'Perempuan', '6282219111996', '2019-02-13', '2025-06-23', '2025-12-24 21:13:39');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (579, '01112025', 'Syakira Almaira Azzahra Hasanah', 'Perempuan', '6282349200192', '2019-04-06', '2025-07-09', '2025-12-24 21:15:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (580, '01122025', 'Safaraz Akma Fadil Hasan', 'Laki-Laki', '6282349200192', '2020-08-16', '2025-06-09', '2025-12-24 21:17:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (581, '01132025', 'Fatiyya Nafisa', 'Perempuan', '6285264396782', '2018-12-03', '2025-07-01', '2025-12-24 21:19:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (582, '01142025', 'Ayeisha Leticia', 'Perempuan', '6281398183183', '2018-07-11', '2025-09-01', '2025-12-24 21:20:33');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (583, '01152025', 'Mikayla Alshira Salsabila', 'Perempuan', '6281287646489', '2019-05-30', '2025-09-20', '2025-12-24 21:22:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (584, '01162025', 'Syafiyah Prastya', 'Perempuan', '6282258545542', '2019-10-23', '2025-08-10', '2026-01-03 23:30:23');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (585, '01172025', 'Alisha Zaen Salsabila', 'Perempuan', '6285975286682', '2020-06-14', '2025-07-21', '2026-01-03 23:32:04');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (586, '01182025', 'Nur Syafiqah Humaira', 'Perempuan', '6285767300137', '2020-09-26', '2025-10-02', '2026-01-04 12:38:55');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (587, '01192025', 'Muhammad Raffasya Alfarizkqi', 'Laki-Laki', '6282283756545', '2019-08-19', '2024-01-08', '2026-01-04 12:41:12');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (588, '01202025', 'Muhammad Fathan Faqqihulkim', 'Laki-Laki', '628127758260', '2019-01-09', '2024-02-04', '2026-01-04 12:42:53');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (589, '01212025', 'Muhammad Alvino Wijaya', 'Perempuan', '6281536533501', '2018-04-25', '2024-07-30', '2026-01-04 12:44:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (590, '01222025', 'Nabila Husna', 'Perempuan', '6285272368936', '2019-08-29', '2025-12-03', '2026-01-04 12:46:30');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (591, '01232025', 'Ahza Zea Rumaysha Khairul', 'Perempuan', '6287828298360', '2020-10-19', '2025-09-29', '2026-01-04 12:48:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (592, '01242025', 'Kalya Adifa Pangestu', 'Perempuan', '6282287181153', '2019-10-02', '2025-03-10', '2026-01-04 12:51:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (593, '01252025', 'Syifa Delisa Hakira', 'Perempuan', '6281266069374', '2019-09-15', '2024-09-07', '2026-01-04 12:55:36');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (594, '01262025', 'Al Jabbar Mualik', 'Laki-Laki', '6282386268656', '2019-07-05', '2024-10-13', '2026-01-04 12:57:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (595, '01272025', 'Aiza clamira Ramadhan', 'Perempuan', '6281362424385', '2020-05-18', '2025-08-01', '2026-01-04 13:04:30');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (596, '01282025', 'Muhammad Raffasya Kaysan', 'Laki-Laki', '6282312227087', '2019-12-19', '2025-02-10', '2026-01-04 13:06:03');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (597, '01292025', 'Aura Queenara sabila', 'Perempuan', '6281364011960', '2021-02-14', '2025-09-26', '2026-01-04 13:07:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (598, '01302025', 'Rafisqy Evano Alfareza', 'Laki-Laki', '6282391426447', '2020-07-20', '2025-11-13', '2026-01-04 13:09:31');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (599, '01312025', 'Hanin Dhiya', 'Perempuan', '6282285501345', '2019-06-10', '2024-07-15', '2026-01-04 13:11:26');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (600, '01322025', 'Azkiya Putri Ashima', 'Perempuan', '6281299714470', '2020-04-05', '2025-08-28', '2026-01-04 13:13:19');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (601, '01332025', 'Diajeng Intan Nuraisyah', 'Laki-Laki', '6282289078015', '2020-04-15', '2024-12-02', '2026-01-04 14:46:38');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (602, '01342025', 'Nabila Nurul Huda', 'Perempuan', '6282273696399', '2019-09-23', '2025-08-23', '2026-01-04 14:49:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (603, '01352025', 'Trisha Allahyarham Faiz', 'Perempuan', '6292288204229', '2021-08-19', '2025-07-09', '2026-01-04 17:54:08');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (604, '01362025', 'Aura Balqis Pala', 'Perempuan', '6282169960805', '2019-09-13', '2025-05-16', '2026-01-04 17:55:34');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (605, '01372025', 'Raisha Nafisah Arda', 'Perempuan', '6285201104018', '2018-12-03', '2025-04-21', '2026-01-04 17:58:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (606, '01382025', 'Muhammad Rafardhan Athalla', 'Laki-Laki', '6283157203615', '2019-04-09', '2024-12-02', '2026-01-04 18:00:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (607, '01392025', 'Muhammad Harith Alfatih', 'Laki-Laki', '6282386948446', '2018-09-08', '2024-12-02', '2026-01-04 18:01:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (608, '01402025', 'Habil Sidiq', 'Laki-Laki', '6285265874637', '2018-07-20', '2015-05-27', '2026-01-04 18:03:15');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (609, '01412025', 'Hisyam Putra Kusnadi', 'Laki-Laki', '6285264452323', '2018-12-18', '2025-04-21', '2026-01-04 18:06:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (610, '01422025', 'Hanifa Shahia Almahyra', 'Perempuan', '6285947702853', '2018-12-01', '2025-04-20', '2026-01-04 18:07:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (611, '01432025', 'Raja Fajar Altami Adanu', 'Laki-Laki', '6285184095734', '2020-12-06', '2025-05-09', '2026-01-04 18:09:11');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (612, '0144', 'Kalamira Syamika', 'Perempuan', '6281378987928', '2019-11-30', '2025-08-04', '2026-01-04 18:10:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (613, '01452025', 'Haikal Pratamw', 'Laki-Laki', '6281363574891', '2017-12-12', '2025-09-17', '2026-01-04 18:12:37');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (614, '01462025', 'Ifra Azka Mikayla', 'Perempuan', '6281363724677', '2020-09-29', '2025-09-08', '2026-01-04 18:14:15');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (615, '01472025', 'Raja Uzma', 'Perempuan', '181270048978', '2018-09-22', '2025-10-06', '2026-01-04 18:15:39');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (616, '01482025', 'Muhammad Khalid Al Ayyubi', 'Laki-Laki', '6288272081893', '2020-04-28', '2025-10-27', '2026-01-04 18:17:02');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (617, '01492025', 'M. Rizki Haaziq', 'Laki-Laki', '6285264196857', '2019-04-01', '2024-12-02', '2026-01-04 18:18:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (618, '01502025', 'Muhammad Harraz Alfarazel', 'Laki-Laki', '6282268196699', '2019-02-12', '2025-01-08', '2026-01-04 18:20:28');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (619, '01512025', 'Nawreen Mikayla', 'Perempuan', '628126990185', '2019-09-16', '2025-05-01', '2026-01-04 23:00:52');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (620, '01522025', 'Kiano Thaqif Nayuri', 'Laki-Laki', '6281364708043', '2019-04-19', '2025-07-25', '2026-01-04 23:02:35');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (621, '01532025', 'Arsyah Rizky Pahlevi', 'Laki-Laki', '6281261779100', '2020-06-07', '2025-07-14', '2026-01-04 23:04:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (622, '01542025', 'Alisha Naura Farzana', 'Perempuan', '6281372792887', '2019-10-05', '2025-07-18', '2026-01-04 23:06:16');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (623, '01552025', 'Reza Aydhill Pratama', 'Laki-Laki', '62811', '2016-09-18', '2025-09-20', '2026-01-04 23:08:11');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (624, '01562026', 'Ghaida Nasha Rezeta', 'Perempuan', '6285365092225', '2020-02-28', '2024-07-04', '2026-01-22 12:08:50');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (625, '01572025', 'Muhammad Arkha Arlian', 'Laki-Laki', '6285212337575', '2017-08-04', '2025-02-03', '2026-01-22 12:10:28');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (626, '01582025', 'Keyva Humaira Syaputri', 'Perempuan', '6281277999378', '2020-02-07', '2025-02-03', '2026-01-22 12:12:17');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (627, '01592025', 'Muhammad Habiburrahman', 'Laki-Laki', '6285194805810', '2019-10-05', '2024-10-16', '2026-01-22 12:15:23');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (628, '01602025', 'Muhammad Naufal Algjifary', 'Laki-Laki', '6281272931342', '2019-05-24', '2024-06-26', '2026-01-22 12:17:27');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (629, '01612025', 'Zhafirah Nurhafizah', 'Perempuan', '6285278108540', '2018-06-05', '2025-05-16', '2026-01-22 12:19:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (630, '01622025', 'Al Mahdi Nurhamdi ', 'Laki-Laki', '6285278108540', '2015-10-16', '2025-07-14', '2026-01-22 12:21:36');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (631, '01632025', 'Advan putra Nufrianto', 'Laki-Laki', '6281378408609', '2016-12-05', '2025-07-28', '2026-01-22 12:51:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (632, '01642025', 'Naufal Farzana', 'Perempuan', '6282287648050', '2017-05-07', '2023-05-30', '2026-01-28 07:10:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (633, '01652025', 'Almeera Azzahra Fathunnisa', 'Perempuan', '628117567722', '2017-06-08', '2024-11-15', '2026-01-28 07:13:21');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (634, '01662025', 'Muhammad Absyar Alhaziq', 'Laki-Laki', '6282288005219', '2017-11-20', '2024-06-28', '2026-01-28 07:14:57');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (635, '01672025', 'Ihsan Septianda', 'Laki-Laki', '6281261373117', '2017-09-16', '2024-08-07', '2026-01-28 07:16:21');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (636, '01682025', 'Muhammad Aidil Sagufta', 'Laki-Laki', '6281374984442', '2018-08-21', '2025-02-04', '2026-01-28 08:26:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (637, '01692025', 'Dzikranisa Aina Yafie', 'Perempuan', '6282383581578', '2017-03-06', '2025-07-30', '2026-01-28 08:27:59');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (638, '01712025', 'Naziha Humairah', 'Perempuan', '6282382953308', '2016-08-22', '2023-04-05', '2026-01-28 08:29:41');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (639, '01722025', 'Muhammad Parsa Muzakki', 'Laki-Laki', '6282382953308', '2024-12-05', '2018-03-20', '2026-01-28 08:31:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (640, '01732025', 'Cinta Navisyaqilla Putri', 'Perempuan', '6285264916792', '2020-02-04', '2025-04-14', '2026-01-28 08:32:44');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (641, '01742025', 'Amelina Nur Adzkiya', 'Perempuan', '6285363863651', '2019-07-03', '2025-06-11', '2026-01-28 08:34:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (642, '01752025', 'Salma Rahmadiya Sudrajad', 'Perempuan', '6281270797996', '2017-08-24', '2023-03-03', '2026-01-28 08:35:30');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (643, '01702025', 'Farisha Alma Yafie', 'Perempuan', '6282383581578', '2019-12-12', '2024-07-30', '2026-01-28 08:47:20');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (644, '01762025', 'Aimar Tsaqib Rizq', 'Laki-Laki', '6281268849404', '2019-02-12', '2024-04-29', '2026-01-28 11:06:13');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (645, '01782025', 'Rosmawati', 'Perempuan', '6281269544228', '2018-03-21', '2018-09-15', '2026-01-28 11:07:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (646, '01792025', 'Medina Assyifa', 'Perempuan', '6282284932233', '2019-10-06', '2024-12-02', '2026-01-28 11:08:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (647, '01802025', 'Shazea Ulayya Dzahim', 'Perempuan', '6285315820471', '2021-01-14', '2025-01-10', '2026-01-28 11:10:22');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (648, '01812025', 'Syakila Noara Adzkia', 'Perempuan', '6282287823896', '2025-01-08', '2024-10-15', '2026-01-28 11:12:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (649, '01822026', 'Davi andra Alrescha Pradipta', 'Laki-Laki', '6281277375891', '2018-03-13', '2023-06-28', '2026-02-03 17:10:53');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (650, '01832025', 'Raja Kayzan', 'Laki-Laki', '6285264630448', '2020-09-28', '2025-05-15', '2026-02-03 17:12:14');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (651, '01842025', 'Devania Khalisa Rescha Putri', 'Perempuan', '6281277375891', '2019-12-03', '2024-06-08', '2026-02-03 17:13:58');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (652, '01852026', 'Divia Chayra Rescha Putri', 'Perempuan', '6281277375891', '2021-03-13', '2025-02-10', '2026-02-03 17:15:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (653, '01862025', 'Bara Abizar Algofari', 'Laki-Laki', '6281343448122', '2018-11-28', '2023-10-31', '2026-02-03 17:17:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (654, '01872025', 'Syahira', 'Perempuan', '6285278079953', '2019-12-28', '2025-07-14', '2026-02-03 17:18:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (655, '01882025', 'Azalea Khaliqa Dzahin', 'Perempuan', '6282170152626', '2017-10-23', '2023-10-27', '2026-02-03 17:20:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (656, '01892025', 'Dimas Nafis Pratama', 'Laki-Laki', '62861441486', '2017-11-23', '2025-02-10', '2026-02-03 17:22:27');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (657, '01902025', 'Asheeqa Althafunnisa', 'Perempuan', '6285264779423', '2018-09-26', '2024-07-17', '2026-02-03 17:23:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (658, '01912025', 'Aleesha Khalisa Putri', 'Perempuan', '6285264779423', '2015-07-07', '2025-01-06', '2026-02-03 17:32:32');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (659, '01922025', 'Nuraida Olan Ryanda', 'Perempuan', '6283896437537', '2020-11-07', '2025-06-18', '2026-02-03 17:34:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (660, '01932025', 'Gendis Enggar Arimbi', 'Perempuan', '6282170696477', '2020-08-10', '2024-10-09', '2026-02-04 11:50:27');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (661, '01942025', 'Kayyisa Syafiq Siregar', 'Perempuan', '6282174080821', '2018-04-02', '2024-01-15', '2026-02-04 11:51:55');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (662, '01952025', 'Aulia Raisya Noshaba', 'Perempuan', '6282221173713', '2017-07-14', '2023-10-27', '2026-02-04 11:53:24');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (663, '01962025', 'Alula Noshaba', 'Perempuan', '6282221173713', '2019-06-23', '2025-10-06', '2026-02-04 11:54:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (664, '01972025', 'Faradilla', 'Perempuan', '6282268758378', '2017-10-22', '2025-04-30', '2026-02-04 11:56:50');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (665, '01982025', 'Muhammad Azizul Hakim', 'Laki-Laki', '6282110768244', '2022-08-19', '2024-07-01', '2026-02-04 11:58:18');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (666, '01992025', 'M Alfath Fitria  Dzaky', 'Laki-Laki', '6282183168518', '2019-06-12', '2025-06-05', '2026-02-04 12:00:15');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (667, '02002025', 'Syafiq Fathani', 'Laki-Laki', '6281270101332', '2017-03-20', '2025-10-06', '2026-02-04 12:02:21');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (668, '02012025', 'Anindita Keysha Zahra', 'Perempuan', '628116935726', '2015-09-23', '2024-12-16', '2026-02-04 12:03:50');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (669, '02022025', 'Siti Nurhasanah', 'Perempuan', '6285265311855', '2017-02-16', '2025-02-01', '2026-02-04 12:05:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (670, '02032025', 'Zayn AL Mubarak', 'Laki-Laki', '6283137419295', '2019-06-15', '2025-06-21', '2026-02-04 12:06:19');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (671, '02042025', 'Azizah Azkadina', 'Perempuan', '6281299714470', '2018-12-25', '2025-01-30', '2026-02-04 17:35:33');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (672, '02052025', 'Devi Septia', 'Perempuan', '6282288854115', '2017-09-12', '2025-10-30', '2026-02-04 22:48:35');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (673, '02062025', 'Saddam Alfarizqi', 'Laki-Laki', '6281275778609', '2018-10-16', '2025-11-03', '2026-02-04 22:50:06');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (674, '02072025', 'Fatihul Yusri', 'Laki-Laki', '6281995704851', '2021-05-21', '2025-11-12', '2026-02-05 07:33:00');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (675, '02092025', 'Nur Alif Hamizan', 'Laki-Laki', '6289601321366', '2016-09-12', '2025-10-30', '2026-02-05 07:35:34');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (676, '02102025', 'Raja Malik Almubaraq', 'Laki-Laki', '6281277998678', '2018-03-27', '2025-10-03', '2026-02-05 07:36:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (677, '02112025', 'Nurvita Kurnia', 'Perempuan', '6285264993189', '2015-04-25', '2025-04-10', '2026-02-05 07:40:19');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (678, '02122025', 'Reynand Arzan Artanabil', 'Laki-Laki', '62812276184876', '2018-01-07', '2025-10-27', '2026-02-05 07:43:33');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (679, '02132025', 'M ihsan', 'Laki-Laki', '6282391877570', '2017-11-01', '2025-11-03', '2026-02-05 07:47:54');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (680, '02142025', 'Shakiel Azraki Fhatian', 'Laki-Laki', '6282284277686', '2018-01-19', '2025-11-05', '2026-02-05 07:49:15');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (681, '02152025', 'Syafiq', 'Laki-Laki', '6287747450959', '2020-10-17', '2025-12-02', '2026-02-05 07:56:51');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (682, '02162025', 'Besse Rara Alesha', 'Perempuan', '6281266062573', '2019-06-02', '2025-11-27', '2026-02-05 07:58:09');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (683, '02172025', 'Adrian Alhafidz', 'Laki-Laki', '6281261779100', '2015-10-27', '2025-10-30', '2026-02-05 08:00:43');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (684, '02182025', 'Devi Septia', 'Perempuan', '6282288854115', '2017-09-12', '2025-10-30', '2026-02-05 08:02:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (685, '02192025', 'Rasqa Albima Janitra', 'Laki-Laki', '6285271115652', '2018-12-23', '2025-12-01', '2026-02-05 08:04:49');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (686, '02082025', 'Hilya Andini Ely', 'Perempuan', '6282288252022', '2021-12-28', '2025-12-02', '2026-02-05 08:06:02');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (687, '02202025', 'Shaquille Emran Arrrasya', 'Laki-Laki', '6281270857101', '2020-12-14', '2025-07-28', '2026-02-05 08:37:10');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (688, '02412025', 'Aulian Dalah Kurnila', 'Laki-Laki', '6285264993189', '2017-09-27', '2025-04-10', '2026-02-05 08:39:12');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (689, '02222024', 'Nayyara Zea Zhaafira', 'Perempuan', '6281364922498', '2019-10-19', '2025-10-14', '2026-02-05 08:41:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (690, '02232025', 'Naufalyn Alesha Rabbani', 'Perempuan', '6282174086867', '2019-10-03', '2025-09-16', '2026-02-05 08:42:36');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (691, '02242025', 'Muhammad khairul Rahman', 'Laki-Laki', '6282165362484', '2014-05-09', '2025-10-28', '2026-02-05 08:44:07');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (692, '02252025', 'Daffa mahardika utomo', 'Laki-Laki', '6285261777722', '2016-11-04', '2024-10-01', '2026-02-06 16:06:35');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (693, '02262025', 'Andra Abinaya utomo', 'Laki-Laki', '628261777722', '2015-09-03', '2024-11-01', '2026-02-06 16:08:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (694, '02292025', 'M Uwais AL Qarni', 'Laki-Laki', '6282283003629', '2019-10-29', '2025-06-09', '2026-02-06 16:09:41');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (695, '02302025', 'Faradina', 'Perempuan', '6283807319799', '2019-09-01', '2025-06-10', '2026-02-06 16:15:01');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (696, '02312025', 'Raja Aditya Naufal', 'Laki-Laki', '6281277998678', '2015-06-20', '2025-10-06', '2026-02-06 16:16:05');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (697, '02322025', 'Audrey Anindya Antana', 'Perempuan', '6281262659324', '2018-07-24', '2024-10-19', '2026-02-06 16:17:45');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (698, '02332025', 'Wan Ahmad Syafiq', 'Laki-Laki', '6282283673362', '2019-02-19', '2025-01-21', '2026-02-06 16:18:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (699, '02342025', 'Muhammad Haekal Dinata', 'Laki-Laki', '6281328473773', '2020-11-09', '2025-05-19', '2026-02-06 16:20:14');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (700, '02352025', 'Ya’qub', 'Laki-Laki', '6285274237771', '2017-08-07', '2024-12-19', '2026-02-07 10:37:30');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (701, '02362025', 'Adam Febrian', 'Laki-Laki', '6282272516789', '2018-02-19', '2025-10-20', '2026-02-07 10:38:40');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (702, '02372025', 'Alvii Alisha Tristi Theysen', 'Perempuan', '6287810558693', '2015-01-15', '2025-07-28', '2026-02-07 10:40:25');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (703, '02392025', 'Alika Naila Putri Afifah', 'Perempuan', '6285264366571', '2016-08-01', '2025-09-16', '2026-02-07 10:41:59');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (704, '02402025', 'Muhammad Harith', 'Laki-Laki', '6281372972781', '2020-06-08', '2025-10-06', '2026-02-07 10:46:16');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (705, '02422025', 'Hanandya Yasmine', 'Perempuan', '6281267232333', '2018-07-03', '2025-08-05', '2026-02-07 10:47:29');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (706, '02212025', 'Ayna Azkayra', 'Perempuan', '6281267232333', '2020-05-25', '2025-09-08', '2026-02-07 10:48:56');
INSERT INTO `tb_siswa` (`id`, `noInduk`, `nama`, `jenisKelamin`, `telp`, `tglLahir`, `tglMasuk`, `terdaftar`) VALUES (707, '02412025', 'Aulian Falah Kurnila', 'Laki-Laki', '6285264993189', '2017-09-27', '2025-04-10', '2026-02-07 10:50:19');


#
# TABLE STRUCTURE FOR: tb_tagihan
#

DROP TABLE IF EXISTS `tb_tagihan`;

CREATE TABLE `tb_tagihan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idAdmin` int(11) NOT NULL,
  `bulan` int(11) NOT NULL,
  `tahun` int(11) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan` (`id`, `idAdmin`, `bulan`, `tahun`, `terdaftar`) VALUES (59, 1, 1, 2026, '2026-01-13 16:15:25');


#
# TABLE STRUCTURE FOR: tb_tagihan_siswa
#

DROP TABLE IF EXISTS `tb_tagihan_siswa`;

CREATE TABLE `tb_tagihan_siswa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idTagihan` int(11) NOT NULL,
  `idAdmin` int(11) NOT NULL,
  `idSiswa` int(11) NOT NULL,
  `idKelas` int(11) NOT NULL,
  `nominal` varchar(16) NOT NULL,
  `tgl` int(11) NOT NULL,
  `status` varchar(16) NOT NULL,
  `jam` time NOT NULL,
  `tglBayar` date NOT NULL,
  `approve` varchar(64) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4722 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4588, 59, 1, 466, 35, '130000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4589, 59, 1, 468, 38, '210000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4590, 59, 1, 469, 38, '130000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4591, 59, 1, 470, 38, '210000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4592, 59, 1, 471, 38, '120000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4593, 59, 1, 472, 38, '350000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4594, 59, 1, 473, 38, '130000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4595, 59, 1, 474, 38, '130000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4596, 59, 1, 475, 38, '210000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4597, 59, 1, 476, 38, '130000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4598, 59, 1, 477, 38, '200000', 24, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4599, 59, 1, 478, 38, '200000', 24, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4600, 59, 1, 479, 38, '210000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4601, 59, 1, 480, 38, '130000', 18, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4602, 59, 1, 481, 38, '130000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4603, 59, 1, 482, 38, '120000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4604, 59, 1, 483, 38, '130000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4605, 59, 1, 484, 38, '190000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4606, 59, 1, 485, 38, '130000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4607, 59, 1, 486, 38, '210000', 22, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4608, 59, 1, 487, 38, '300000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4609, 59, 1, 488, 38, '200000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4610, 59, 1, 489, 38, '130000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4611, 59, 1, 501, 36, '250000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4612, 59, 1, 500, 36, '210000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4613, 59, 1, 499, 36, '130000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4614, 59, 1, 498, 36, '210000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4615, 59, 1, 497, 36, '130000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4616, 59, 1, 496, 36, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4617, 59, 1, 495, 36, '150000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4618, 59, 1, 494, 36, '130000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4619, 59, 1, 493, 36, '130000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4620, 59, 1, 492, 36, '210000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4621, 59, 1, 490, 36, '190000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4622, 59, 1, 491, 36, '130000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4623, 59, 1, 502, 39, '120000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4624, 59, 1, 503, 39, '200000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4625, 59, 1, 504, 39, '130000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4626, 59, 1, 505, 39, '300000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4627, 59, 1, 506, 39, '300000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4628, 59, 1, 507, 39, '150000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4629, 59, 1, 508, 39, '130000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4630, 59, 1, 509, 39, '190000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4631, 59, 1, 510, 41, '220000', 30, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4632, 59, 1, 511, 41, '150000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4633, 59, 1, 512, 41, '150000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4634, 59, 1, 513, 41, '150000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4635, 59, 1, 517, 41, '230000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4636, 59, 1, 516, 41, '150000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4637, 59, 1, 515, 41, '150000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4638, 59, 1, 514, 41, '230000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4639, 59, 1, 518, 41, '220000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4640, 59, 1, 519, 41, '150000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4641, 59, 1, 520, 41, '150000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4642, 59, 1, 521, 41, '150000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4643, 59, 1, 522, 41, '150000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4644, 59, 1, 523, 41, '150000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4645, 59, 1, 524, 41, '150000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4646, 59, 1, 525, 41, '150000', 27, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4647, 59, 1, 526, 41, '150000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4648, 59, 1, 527, 41, '150000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4649, 59, 1, 528, 41, '150000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4650, 59, 1, 529, 41, '230000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4651, 59, 1, 530, 41, '230000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4652, 59, 1, 531, 41, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4653, 59, 1, 532, 41, '230000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4654, 59, 1, 533, 41, '230000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4655, 59, 1, 534, 42, '130000', 31, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4656, 59, 1, 535, 42, '130000', 12, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4657, 59, 1, 536, 42, '130000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4658, 59, 1, 537, 42, '130000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4659, 59, 1, 538, 42, '210000', 19, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4660, 59, 1, 539, 42, '130000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4661, 59, 1, 540, 42, '210000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4662, 59, 1, 541, 42, '130000', 26, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4663, 59, 1, 542, 42, '130000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4664, 59, 1, 543, 42, '130000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4665, 59, 1, 544, 42, '130000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4666, 59, 1, 545, 42, '130000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4667, 59, 1, 546, 42, '210000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4668, 59, 1, 547, 42, '210000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4669, 59, 1, 548, 42, '130000', 27, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4670, 59, 1, 549, 42, '130000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4671, 59, 1, 553, 37, '230000', 6, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4672, 59, 1, 552, 37, '150000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4673, 59, 1, 551, 37, '150000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4674, 59, 1, 550, 37, '150000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4675, 59, 1, 557, 37, '230000', 11, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4676, 59, 1, 556, 37, '150000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4677, 59, 1, 555, 37, '150000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4678, 59, 1, 554, 37, '150000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4679, 59, 1, 558, 37, '150000', 17, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4680, 59, 1, 559, 37, '150000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4681, 59, 1, 560, 37, '130000', 30, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4682, 59, 1, 561, 37, '230000', 31, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4683, 59, 1, 562, 37, '150000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4684, 59, 1, 563, 37, '150000', 25, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4685, 59, 1, 564, 37, '230000', 5, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4686, 59, 1, 565, 37, '0', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4687, 59, 1, 566, 43, '210000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4688, 59, 1, 567, 43, '130000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4689, 59, 1, 568, 43, '130000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4690, 59, 1, 569, 43, '190000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4691, 59, 1, 573, 43, '120000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4692, 59, 1, 572, 43, '200000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4693, 59, 1, 571, 43, '210000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4694, 59, 1, 570, 43, '130000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4695, 59, 1, 577, 43, '130000', 14, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4696, 59, 1, 576, 43, '190000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4697, 59, 1, 575, 43, '130000', 16, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4698, 59, 1, 574, 43, '210000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4699, 59, 1, 583, 44, '150000', 20, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4700, 59, 1, 582, 44, '230000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4701, 59, 1, 581, 44, '150000', 1, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4702, 59, 1, 580, 44, '150000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4703, 59, 1, 579, 44, '150000', 9, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4704, 59, 1, 578, 44, '230000', 23, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4705, 59, 1, 584, 36, '130000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4706, 59, 1, 585, 36, '190000', 21, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4707, 59, 1, 586, 45, '300000', 2, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4708, 59, 1, 600, 45, '200000', 28, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4709, 59, 1, 599, 45, '130000', 15, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4710, 59, 1, 598, 45, '210000', 13, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4711, 59, 1, 597, 45, '190000', 26, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4712, 59, 1, 596, 45, '130000', 19, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4713, 59, 1, 595, 45, '130000', 19, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4714, 59, 1, 594, 45, '200000', 13, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4715, 59, 1, 593, 45, '130000', 7, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4716, 59, 1, 592, 45, '320000', 10, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4717, 59, 1, 591, 45, '300000', 29, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4718, 59, 1, 590, 45, '130000', 3, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4719, 59, 1, 589, 45, '130000', 30, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4720, 59, 1, 588, 45, '130000', 4, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');
INSERT INTO `tb_tagihan_siswa` (`id`, `idTagihan`, `idAdmin`, `idSiswa`, `idKelas`, `nominal`, `tgl`, `status`, `jam`, `tglBayar`, `approve`, `terdaftar`) VALUES (4721, 59, 1, 587, 45, '130000', 8, 'Belum Bayar', '00:00:00', '0000-00-00', '', '2026-01-13 16:15:25');


#
# TABLE STRUCTURE FOR: tb_user
#

DROP TABLE IF EXISTS `tb_user`;

CREATE TABLE `tb_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nama` varchar(256) NOT NULL,
  `jenisKelamin` varchar(32) NOT NULL,
  `telp` varchar(16) NOT NULL,
  `email` varchar(256) NOT NULL,
  `alamat` text NOT NULL,
  `username` varchar(256) NOT NULL,
  `password` varchar(256) NOT NULL,
  `foto` varchar(128) NOT NULL,
  `skin` varchar(8) NOT NULL,
  `level` varchar(16) NOT NULL,
  `login` varchar(8) NOT NULL,
  `terdaftar` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `tb_user` (`id`, `nama`, `jenisKelamin`, `telp`, `email`, `alamat`, `username`, `password`, `foto`, `skin`, `level`, `login`, `terdaftar`) VALUES (1, 'Maratus Sholeha', 'Perempuan', '62811775464', 'kbtulip789@gmail.com', 'Pamak, Teluk Uma Kec. Tebing Kab. Karimun Kepulauan Riau', 'Admin', '$2a$12$hEtLejWWccjYUQIMYrB7sunWQZYOa8ihjQy09Meu2IcWdFllbgI2C', 'no-image.png', 'yellow', 'Administrator', 'Ya', '2025-11-29 08:56:00');


